package gov.va.caret.view;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.portlet.PortletRequest;

import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Junction;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.bean.AssmtAuditBean;
import gov.va.caret.controller.dashboard.config.DashboardConfig;
import gov.va.caret.model.Assmt;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.Call;
import gov.va.caret.model.Persn;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.AudLgImpl;
import gov.va.caret.model.impl.CallImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.impl.VcgImpl;
import gov.va.caret.model.impl.WorImImpl;
import gov.va.caret.model.support.AssmtSupport;
import gov.va.caret.model.support.AuditLogSupport;
import gov.va.caret.model.support.DocumentSupport;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.AssmtLocalServiceUtil;
import gov.va.caret.service.AudLgLocalServiceUtil;
import gov.va.caret.service.CallLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;

public class CachedReport extends GenericReport {

	public CachedReport(String reportName) {
		super(reportName);
	}
	
	
	
	
	//TODO: make this flexible for any search
	public void run ( PortletRequest request, boolean loadFromParams, int start, int end ){
		
		List report = Collections.emptyList();
		boolean setSize = true;
		try {
			if ( "vcgs".equals( getName( )) ){
				report = getVcgList ( request, start, end );
				setSize = false;
			} else if ( "workItems".equals( getName() ) ){
				report = getWorkItemList(request, start, end);
				setSize = false;
			} else if ( "assmtAudit".equals( getName() ) ){
				report = getAssmtAudit ( request, start, end );
			} else if ( "assmtAuditAll".equals( getName() ) ){
				report = getAssmtAuditAll ( request, start, end, CaretStrPool.ASSMT_INITIAL);
			} else if ( "assmtAuditPeriodicAll".equals( getName() ) ){ 
				report = getAssmtAuditAll ( request, start, end, CaretStrPool.ASSMT_PERIODIC);
			} else if ( "periodicAssessmentsAll".equals( getName() ) ){ 
				report = getPeriodicAssessmentsAll(request, start, end);
			}else if ( "workAudit".equals( getName() ) ||
					"persnAudit".equals( getName() ) ||
					"vcgAudit".equals( getName() )  ||
					"callAudit".equals( getName() ) ){
				report = getAudit ( request, start -1, end );
				setSize = false;
			} else if ( CaretStrPool.CALLS.equals( getName() ) || CaretStrPool.REFFERALS.equals( getName() ) ){
				report = getCallList(request, start, end);
				setSize = false;
			}else if("vcgSupportingDocsAll".equals(getName())){
				report = getVcgSupportingDocsAll ( request, start, end );
			}else if("vcgDocsHistoryAll".equals(getName())){
				report = getVcgDocsHistoryAll(request, start, end);
			}
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
	 	ResultMap.getResultListMap( request ).put( getName(), report );
	 	if ( setSize ){
	 		ResultMap.getResultTotalMap( request ).put( getName(), report.size() );
	 	}

		ResultMap.getResultOrderDeltaMap( request ).put(getName(), end == 0 ? SearchContainer.DEFAULT_DELTA : start-end );
		 
	}
	
	private List<AudLg> getAudit(PortletRequest request, int start, int end ) {
		DynamicQuery[] dq = getDqPair(AudLgImpl.class);
		dq[0].add( PropertyFactoryUtil.forName( "classPk" ).eq( ParamUtil.getLong(request, "classPk" ) ) ).addOrder( OrderFactoryUtil.desc("modifiedDate") );
		dq[1].add( PropertyFactoryUtil.forName( "classPk" ).eq( ParamUtil.getLong(request, "classPk" ) ) );
		List<AudLg> report = new ArrayList<AudLg>();
		try {
			@SuppressWarnings("unchecked")
			List<AudLg> list = (List<AudLg>) AudLgLocalServiceUtil.dynamicQuery( dq[0], start, end );
			for ( AudLg audLg:  list ){
				report.add( new AuditLogSupport(audLg) );
			}
			ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( AudLgLocalServiceUtil.dynamicQueryCount( dq[1] ) ).intValue() );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return report;
	}

	
	private List getAssmtAudit(PortletRequest request, int start, int end) {
		
		DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( AudLgImpl.class, PortletClassLoaderUtil.getClassLoader() );
		dynamicQuery.add( PropertyFactoryUtil.forName( "classPk" ).eq( ParamUtil.getLong(request, CaretStrPool.ASSMT_ID ) ) )
		.addOrder( OrderFactoryUtil.desc("modifiedDate") );

		List report = new ArrayList();
		try {
			List<AudLg> list = (List<AudLg>) AudLgLocalServiceUtil.dynamicQuery( dynamicQuery, start, end );

			for ( AudLg audLg:  list ){

			    if(audLg.getAttribute().equals("completionDate"))
			    {
					try {
						//EEE MMM dd HH:mm:ss z yyyy
						if(audLg.getOldValue()!= null && !audLg.getOldValue().equals("null")){
							Date oldValue = (Date) Toolbox.getDateTimeFormatExpanded().parseObject(audLg.getOldValue());
							audLg.setOldValue(Toolbox.getDateFormatCprs().format(oldValue));
						}else if(audLg.getOldValue()!= null && audLg.getOldValue().equals("null")){
							audLg.setOldValue("");
						}
	
				    	Date newValue = (Date) Toolbox.getDateTimeFormatExpanded().parseObject(audLg.getNewValue());
				    	audLg.setNewValue(Toolbox.getDateFormatCprs().format(newValue));
					} catch (ParseException e) {
						ApplicationWorkFlowException.handleException(e);
					}
			    }
				
				report.add( new AuditLogSupport(audLg) );
			}
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return report;
	}

	private List getAssmtAuditAll(PortletRequest request, int start, int end, String category)
	{
		List<AssmtAuditBean> allHistory = new ArrayList<AssmtAuditBean>();
		
		try 
		{	
			long vcgId = ParamUtil.getLong(request, "vcgId", 0);

			Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("vcgId", Long.toString(vcgId));	
			
			String assmtTypes = "";
			if(category.equals(CaretStrPool.ASSMT_INITIAL)){
				assmtTypes = "'"+CaretStrPool.PRIMARY_ASSESSMENT+"','"+CaretStrPool.PRIMARY_CLINICAL+"','"+CaretStrPool.PRIMARY_TRAINING+"','"+CaretStrPool.PRIMARY_IN_HOME
						+"','"+CaretStrPool.SECONDARY_ASSESSMENT+"','"+CaretStrPool.SECONDARY_CLINICAL+"','"+CaretStrPool.SECONDARY_TRAINING
						+"','"+CaretStrPool.SECONDARY_TWO_ASSESSMENT+"','"+CaretStrPool.SECONDARY_TWO_ASSESSMENT+"','"+CaretStrPool.SECONDARY_TWO_ASSESSMENT+"'";
			}else{
				assmtTypes = "'"+CaretStrPool.QUARTER1+"','"+CaretStrPool.QUARTER2+"','"+CaretStrPool.QUARTER3+"','"+CaretStrPool.ANNUAL+"'";
			}
			
			paramMap.put("assmtTypes", assmtTypes);	
			
			List<Map<String, Object>> list = CaretLocalServiceUtil.getReport("assmtHistoryAll", paramMap, start, end);
			
			AssmtAuditBean oneHistory;
			for (Map<String, Object> map : list) {
				oneHistory = new AssmtAuditBean();

			    for (Map.Entry<String, Object> entry : map.entrySet()) {
			        String key = entry.getKey();
			        String value = entry.getValue().toString();
			        
			        //System.out.println("key/value pair is :"+key+"/"+value);
			        //For reference
			        //ndx0 - audlgid - audit id	//ndx1 - classpk - assmt id	//ndx2 - attribute	//ndx3 - oldvalue	//ndx4 - newvalue	//ndx5 - modifiedbyid
			        //ndx6 - modifieddate	//ndx7 - (prsn.lastname ||', '|| prsn.firstname)	//ndx8 - assmt.TYPE_	
			        	
			        if(key.equals("ndx1")){
			        	oneHistory.setAuditLogId(value);
			        }else if(key.equals("ndx3")){
			        	oneHistory.setAttribute(value);
			        }if(key.equals("ndx4")){
			        	oneHistory.setOldValue(value);
			        }else if(key.equals("ndx5")){
			        	oneHistory.setNewValue(value);
			        }else if(key.equals("ndx7")){
			        	oneHistory.setModifiedDate(value);
			        }else if(key.equals("ndx8")){
			        	oneHistory.setModifiedByName(value);
			        }else if(key.equals("ndx9")){
			        	oneHistory.setAssmtType(value);
			        }else if(category.equals(CaretStrPool.ASSMT_PERIODIC) && key.equals("ndx10")){
			        	oneHistory.setScheduleDate(value);
			        }		        
			    }

			    if(oneHistory.getAttribute().equals("completionDate")){
			    	
					try 
					{
						//EEE MMM dd HH:mm:ss z yyyy
						if(oneHistory.getOldValue()!= null && !oneHistory.getOldValue().equals("null")){
							Date oldValue = (Date) Toolbox.getDateTimeFormatExpanded().parseObject(oneHistory.getOldValue());
					    	oneHistory.setOldValue(Toolbox.getDateFormatCprs().format(oldValue));
						}else if(oneHistory.getOldValue()!= null && oneHistory.getOldValue().equals("null")){
							oneHistory.setOldValue("");
						}
	
				    	Date newValue = (Date) Toolbox.getDateTimeFormatExpanded().parseObject(oneHistory.getNewValue());
				    	oneHistory.setNewValue(Toolbox.getDateFormatCprs().format(newValue));
					} catch (ParseException e) {
						ApplicationWorkFlowException.handleException(e);
					}
			    }

			    allHistory.add(oneHistory);
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
		
		return allHistory;
	}
	

	private List getPeriodicAssessmentsAll(PortletRequest request, int start, int end)
	{
		List<AssmtSupport> periodicAssessmentList = new ArrayList<AssmtSupport>();
		try 
		{	
			long vcgId = ParamUtil.getLong(request, "vcgId", 0);
			long primaryId = ParamUtil.getLong(request, "primaryId", 0);
						
			List<Assmt> assessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);

			for(Assmt assessment:assessmentList)
			{
				if(assessment.isActive() && assessment.getCaregiverId()==primaryId
						&& (assessment.getType().equals(CaretStrPool.QUARTER1)||assessment.getType().equals(CaretStrPool.QUARTER2)||assessment.getType().equals(CaretStrPool.QUARTER3)||assessment.getType().equals(CaretStrPool.ANNUAL)))
				{
					AssmtSupport assmtSupport = new AssmtSupport(assessment);
					
					String scheduleDateStr = Toolbox.formatDateCprs(assessment.getScheduleDate());				
					String completionDateStr = Toolbox.formatDateCprs(assessment.getCompletionDate());
										
					assmtSupport.setFormattedScheduleDate(scheduleDateStr);					
					assmtSupport.setFormattedcompletionDate(completionDateStr);		
					periodicAssessmentList.add(assmtSupport);
				}
			}	

		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
		
		return periodicAssessmentList;
	}


	private List<DocumentSupport> getVcgSupportingDocsAll(PortletRequest request, int start, int end)
	{
		List<DocumentSupport> allDocsTemp = new ArrayList<DocumentSupport>();
		List<DocumentSupport> allDocs = new ArrayList<DocumentSupport>();
	
		VcgSupport vcgSupport = null;
		long vcgId = ParamUtil.getLong(request, "vcgId", 0);

		if(vcgId!=0){
			vcgSupport = VcgSupport.getVcgSupport(vcgId);
			vcgSupport.getSupportingDocData();
			allDocsTemp = vcgSupport.getVcgDocsAll();
			
			boolean hasDocumentAccess = false;
			if (CAction.canDoCaret(request, CaretCan.VIEW_DELETED_DOCS.name())){
				hasDocumentAccess = true;
			}
			
			for(DocumentSupport oneDocument:allDocsTemp){
				oneDocument.setHasDocumentAccess(hasDocumentAccess);
				allDocs.add(oneDocument);
			}
		}

		return allDocs;
	}
	
	
	private List<AuditLogSupport> getVcgDocsHistoryAll(PortletRequest request, int start, int end)
	{
		List<AuditLogSupport> allHistory = new ArrayList<AuditLogSupport>();
		
		try 
		{	
			long vcgId = ParamUtil.getLong(request, "vcgId", 0);
			//System.out.println("getVcgDocsHistoryAll : vcgid is : "+vcgId);

			Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("vcgId", Long.toString(vcgId));					
			
			List<Map<String, Object>> list = CaretLocalServiceUtil.getReport("vcgDocsHistoryAll", paramMap, start, end);		
			
			AuditLogSupport oneHistory;
			for (Map<String, Object> map : list) {
				oneHistory = new AuditLogSupport(new AudLgImpl());

			    for (Map.Entry<String, Object> entry : map.entrySet()) {
			        String key = entry.getKey();
			        String value = entry.getValue().toString();
			        
			        //For reference
			        //ndx1 - audlgid - audit id	//ndx2 - classpk - document id	//ndx3 - attribute- Document //ndx4 - oldvalue	//ndx5 - newvalue	//ndx6 - modifiedbyid
			        //ndx7 - modifieddate	//ndx8 - (prsn.lastname ||', '|| prsn.firstname)	//ndx9 - note - doc note //ndx10 - name - doc name	
			        if(value!=null && !value.equals("")){
				        //System.out.println("key/value pair is :"+key+"/"+value);
				        if(key.equals("ndx1")){
				        	oneHistory.setAudLgId(Long.valueOf(value).longValue());
				        }else if(key.equals("ndx3")){
				        	oneHistory.setAttribute(value);
				        }if(key.equals("ndx4")){
				        	oneHistory.setOldValue(value);
				        }else if(key.equals("ndx5")){
				        	oneHistory.setNewValue(value);
				        	//if(!value.equals("DELETED")){
				        	//	oneHistory.setDocDeleteComment("");
				        	//}
				        }else if(key.equals("ndx7")){
				        	oneHistory.setModifiedDateStr(value);
				        }else if(key.equals("ndx8")){
				        	oneHistory.setModifiedByFullName(value);
				        }else if(key.equals("ndx10")){
					        oneHistory.setDocumentName(value);				        						        		
				        }	       			        	
			        }
			    }
			    
			    for (Map.Entry<String, Object> entry : map.entrySet()) {
			        String key = entry.getKey();
			        String value = entry.getValue().toString();

			        if(value!=null && !value.equals("")){
			        	if(key.equals("ndx9")){
				        	if((oneHistory.getNewValue()!=null && oneHistory.getNewValue().equals("DELETED"))){
				        		oneHistory.setDocDeleteComment(value);				        		
				        	}
				        }
			        }
			    }

			    if(oneHistory.getAudLgId()!=0){
				    allHistory.add(oneHistory);			    	
			    }			    
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
		
		return allHistory;
	}

	public List<Vcg> getVcgList ( PortletRequest request, int start, int end ) throws SystemException {
		
		String firstName = request.getParameter("firstName");
		String lastName = request.getParameter("lastName");
//		String ssn = request.getParameter("ssn");
		String birthDate = request.getParameter("birthDate");
		String zip = request.getParameter("zip");//[userOrgIds, lastName, zip, page, primaryKey, ssn, action, birthDate, firstName, fromParameter]
		String roleName = request.getParameter("roleName");
		if ( roleName == null && request.getParameter("roleId") != null ){
			int roleId = ParamUtil.getInteger(request, "roleId", 0);
			switch(roleId){
			case 1: roleName = "veteran"; break;
			case 2: roleName = "primary"; break;
			case 3: roleName = "secondary"; break;
			case 4: roleName = "secondaryTwo"; break;
			default:				
			}
		}
		String primaryKey = request.getParameter("primaryKey");
		
		boolean persnSet = false;
		
		 DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( PersnImpl.class, PortletClassLoaderUtil.getClassLoader() );
		 if ( ! firstName.isEmpty() ){
			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.FIRSTNAME).eq(firstName) );
			 persnSet = true;
		 }
		 
		 if ( ! lastName.isEmpty() ){
			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.LASTNAME).eq(lastName) );
			 persnSet = true;
		 }
		 
		 
//		 if ( ! ssn.isEmpty() ){
//			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.SSN).eq(ssn) );
//			 persnSet = true;
//		 }

		 Collection inList = Collections.emptyList();
		 List report = new ArrayList();
		 
		 if ( persnSet ){
			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.STATUS).eq(CaretStrPool.ACTIVE_VCG) );
			 dynamicQuery.setProjection( PropertyFactoryUtil.forName("persnId") );
			 try {
				inList = PersnLocalServiceUtil.dynamicQuery(dynamicQuery);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			if ( ! inList.isEmpty() ){
				DynamicQuery[] dq = getDqPair(VcgImpl.class);
				Set<Long> groups = getGroups(request);
				for ( DynamicQuery dynQry : dq ){
					if ( !groups.isEmpty() ) {
						dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.GROUP_ID).in(groups));
					}
					dynQry.add(PropertyFactoryUtil.forName(roleName + "Id").in( inList) );
				}

				try {
					 for ( Vcg vcg : (List<Vcg>)VcgLocalServiceUtil.dynamicQuery( dq[0], start, end ) ){
						 report.add( new gov.va.caret.model.support.VcgSupport(vcg) );
					 }
					 ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( VcgLocalServiceUtil.dynamicQueryCount( dq[1] ) ).intValue() );
					 
					 return report;
				 } catch (SystemException e) {
					 ApplicationWorkFlowException.handleException(e);
				 }
			 }
		 } else {
			 try {
				for ( Vcg vcg : VcgLocalServiceUtil.getVcgs(start, end) ){
					report.add( new gov.va.caret.model.support.VcgSupport(vcg) );
				}
				return report;
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		 }
		 
		 return Collections.emptyList(); 
	}
	
	public List<Call> getCallList ( PortletRequest request, int start, int end ) {
		String firstName = request.getParameter("firstName");
		String lastName = request.getParameter("lastName");
//		String ssn = request.getParameter("ssn");
		String birthDateStr = request.getParameter("birthDate");
		
		
		
		
		String beginDateStr = request.getParameter("beginDate");
		String endDateStr = request.getParameter("endDate");
		String roleName = request.getParameter("roleName");
		String phone = request.getParameter("phone");
		String dateType = request.getParameter("dateType");
		String status = request.getParameter("status");
		String callCategory = request.getParameter("callCategory");
		Long responder = ParamUtil.getLong(request, "responder");

		int roleId = ParamUtil.getInteger(request, "roleId", 0);
		if ( roleName == null && request.getParameter("roleId") != null ){
			switch(roleId){
			case 1: roleName = "veteranPersnId"; break;
			case 2: case 3:
			case 4: roleName = "callerPersnId"; break;
			default:				
			}
		}

		boolean persnSet = false;
		
		 DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( PersnImpl.class, PortletClassLoaderUtil.getClassLoader() );
		 
		 if ( roleId == 3 ){
			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.STATUS).eq(CaretStrPool.UNKNOWN_IDENTITY) );
			 persnSet = true;
		 } else {
			 if ( !Toolbox.isEmpty(firstName) ){
				 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.FIRSTNAME).eq(firstName) );
				 persnSet = true;
			 }
			 
			 if ( !Toolbox.isEmpty(lastName) ){
				 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.LASTNAME).eq(lastName) );
				 persnSet = true;
			 }
			 
			 if ( roleId == 1 ){
//				 if ( !Toolbox.isEmpty(ssn) && !Person.SSN_FORMAT.equals(ssn) ){
//					 dynamicQuery.add( PropertyFactoryUtil.forName("persnId").in( DynamicQueryFactoryUtil.forClass( CryptoImpl.class, PortletClassLoaderUtil.getClassLoader() )
//							 .setProjection(ProjectionFactoryUtil.property( "ownerId" ) )
//							 .add(PropertyFactoryUtil.forName("value").eq(ssn) ) ) );
//					 persnSet = true;
//				 }
				 Date birthDate = Toolbox.parseDate(birthDateStr);
				 if ( birthDate != null ){
					 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.BIRTHDATE).eq( birthDate) );
					 persnSet = true;
				 }
				 Set<Long> groups = getGroups(request);
				 if ( !groups.isEmpty() ){
					 dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.GROUP_ID).in(groups));
					 persnSet = true;
				}
			 }
		 }
		 
		 phone = Toolbox.parsePhone(phone);
		 if ( !Toolbox.isEmpty(phone) && roleId > 1 ){
			persnSet = true;
			Junction junction = RestrictionsFactoryUtil.disjunction();
			junction.add( PropertyFactoryUtil.forName("phone").eq(phone) );
			junction.add( PropertyFactoryUtil.forName("phone2").eq(phone) );
			dynamicQuery.add( junction );
		}
		 
//		 Collection inList = Collections.emptyList();
		 

		 List<Call> report = new ArrayList<Call>();
		 @SuppressWarnings("unchecked")
		List<Criterion> criteria = new ArrayList<Criterion>();
		 Criterion c = CaretStrPool.REFFERALS.equals( getName() )? 
				 PropertyFactoryUtil.forName("callType").eq("Referral" ) :
					 PropertyFactoryUtil.forName("callType").ne("Referral" );
		criteria.add(c);
		
		Date beginDate = Toolbox.parseDate(beginDateStr);
		if ( beginDate != null ){
			criteria.add( PropertyFactoryUtil.forName(dateType).gt( beginDate ) );
		}
		Date endDate = Toolbox.parseDate(endDateStr);
		if ( endDate != null ){
			criteria.add( PropertyFactoryUtil.forName(dateType).lt( Toolbox.adjustDate(1, endDate, true) ) );
		}
		
		if ( !Toolbox.isEmpty(status) ){
			criteria.add( PropertyFactoryUtil.forName("callState").eq( status ) );
		}
		
		if ( !Toolbox.isEmpty(callCategory) ){
			criteria.add( PropertyFactoryUtil.forName("callType").eq( callCategory ) );
		}
		
		if ( persnSet ){
			 dynamicQuery.setProjection( PropertyFactoryUtil.forName( CaretStrPool.PERSN_ID ) );
			 try {
				 Collection<Persn> inList = PersnLocalServiceUtil.dynamicQuery(dynamicQuery);
				if ( ! inList.isEmpty() ){
					criteria.add( PropertyFactoryUtil.forName(roleName).in( inList) );
				}
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		 }
		
		DashboardConfig dashConfig = ( DashboardConfig ) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );
		criteria.add(PropertyFactoryUtil.forName("createGroupId").eq( dashConfig.getRoleId() ) );
		if ( responder > 0 ){
			criteria.add(PropertyFactoryUtil.forName("userId").eq( responder ) );
		}
				 
		 DynamicQuery[] dq = getDqPair(CallImpl.class, criteria);

			 try {
				 for ( Call call : (List<Call>)CallLocalServiceUtil.dynamicQuery( dq[0], start, end ) ){
					 report.add( new gov.va.caret.model.support.CallSupport(call) );
				 }
				 ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( CallLocalServiceUtil.dynamicQueryCount( dq[1] ) ).intValue() );
			 } catch (SystemException e) {
				 ApplicationWorkFlowException.handleException(e);
			 }
//		 }
		 return report;
	}
	
	private static Map<String,Set<Long>> groupIdMap = new HashMap<String,Set<Long>>();

	public List<WorIm> getWorkItemList(PortletRequest request, int start, int end) throws SystemException {

		String firstName = request.getParameter("firstName");
		String lastName = request.getParameter("lastName");
		String status = request.getParameter(CaretStrPool.STATUS);
		String workType = request.getParameter("workType");
		String roleName = request.getParameter("roleName");
		String primaryKey = request.getParameter("primaryKey");

		DashboardConfig dashboardConfig = (DashboardConfig) request.getPortletSession()
				.getAttribute(CaretStrPool.DASHBOARD_CONFIG);
		List<WorIm> report = new ArrayList<WorIm>();

		boolean persnSet = false;
		DynamicQuery persnQuery = DynamicQueryFactoryUtil.forClass(PersnImpl.class, 
				PortletClassLoaderUtil.getClassLoader());
		if (firstName != null && !firstName.isEmpty()) {
			persnQuery.add(PropertyFactoryUtil.forName(CaretStrPool.FIRSTNAME).eq(firstName));
			persnSet = true;
		}
		if (lastName != null && !lastName.isEmpty()) {
			persnQuery.add(PropertyFactoryUtil.forName(CaretStrPool.LASTNAME).eq(lastName));
			persnSet = true;
		}

		Collection personList = Collections.emptyList();
		DynamicQuery[] dq = getDqPair(WorImImpl.class);
		try {
			if (persnSet) {
				if (roleName == null && request.getParameter("roleId") != null) {
					int roleId = ParamUtil.getInteger(request, "roleId", 0);
					switch (roleId) {
					case 1:
						roleName = "persnId";
						break;
					case 2:
					case 3:
					case 4:
						roleName = "caregiverId";
						break;
					default:
					}
				}
				personList = PersnLocalServiceUtil
						.dynamicQuery(persnQuery.setProjection(PropertyFactoryUtil.forName(roleName)));
			}
			for ( DynamicQuery dynQry : dq ){
				if (persnSet) {
					dynQry.add(PropertyFactoryUtil.forName(roleName).in(personList));
				}
				if (!Toolbox.isEmpty(workType)) {
					dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.TYPE).eq(workType));
				} else {
					dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.TYPE).in(dashboardConfig.workItemTypes()));
				}
				if (!Toolbox.isEmpty(status)) {
					dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.STATUS).eq(status));
				}
				Set<Long> groups = getGroups( request );
				if (!groups.isEmpty()) {
					dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.GROUP_ID).in(groups));//[21971, 21986, 21991, 21976, 21961, 21996, 21966, 21981]
				}
			}
			for (WorIm worIm : (List<WorIm>) WorImLocalServiceUtil.dynamicQuery(dq[0], start, end)) {
				report.add(new gov.va.caret.model.support.WorkItemSupport(worIm));
			}
			ResultMap.getResultTotalMap( request ).put( getName(), 
					Long.valueOf( WorImLocalServiceUtil.dynamicQueryCount(dq[1])).intValue() );	
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}

		return report;
	}
	
	private Set<Long> getGroups(PortletRequest request) {
		 Set<Long> groups;
		 String groupId = request.getParameter("userOrgIds");
		 if ( !Toolbox.isEmpty( groupId ) ){
			 if ( ParamUtil.getLong(request, "userOrgIds") > 0 || '[' == groupId.charAt(0) || Character.isWhitespace(groupId.charAt(1)) ) {
				 groups = getGroups( request.getParameter("userOrgIds"), request );
			 } else {
				 groups = Collections.singleton(0l);
			 }
		 } else {
			 groups = Collections.EMPTY_SET;
		 }
		 return groups;
	}

	boolean isDistrict( String[] groupIdStr ){
		int digits = 0;
		String temp = null;
		for ( int i = 0; i < groupIdStr[0].length(); i++ ){
			if ( Character.isDigit( groupIdStr[0].charAt(i) ) ){
				temp = String.valueOf( groupIdStr[0].charAt(i) );
				digits++;
			}
			if ( Character.isLetter( groupIdStr[0].charAt(i) ) ){
				groupIdStr[0] = temp;
				break;
			}
		}
		return digits == 1;
	}
	private Set<Long> getGroups(String groupIdStr, PortletRequest request ) {
		Set<Long> groups = Collections.emptySet();
		if ( !Toolbox.isEmpty(groupIdStr) ) {
			String[] groupStr = new String[]{ groupIdStr };
			if (groupIdStr.length() > 1 && isDistrict(groupStr) ) {
				if (groupIdMap.containsKey(groupStr[0])) {
					groups = groupIdMap.get(groupStr[0]);
				} else {
					groups = new HashSet<Long>();
					Organization district;
					try {
						district = OrganizationLocalServiceUtil.fetchOrganization( PortalUtil.getCompanyId( request ), groupIdStr );
						for ( Organization visn: district.getDescendants() ){
							for ( Organization desc: visn.getDescendants() ){
								groups.add(desc.getOrganizationId());
							}
						}
					} catch (SystemException e) {
						ApplicationWorkFlowException.handleException(e);
					}
					groupIdMap.put(groupStr[0],groups);
				}
			} else if ('[' == groupIdStr.charAt(0)) {
				groups = new HashSet<Long>();
				for (String s : groupIdStr.substring(1, groupIdStr.length() - 1).split(StringPool.COMMA_AND_SPACE)) {
					groups.add(Long.valueOf(s));
				}
			} else {
				groups = Collections.singleton(Long.valueOf(groupIdStr));
			}
		}
		return groups;
	}


	private DynamicQuery[] getDqPair( Class<? extends BaseModelImpl<?>> clazz ){
		DynamicQuery[] dq = new DynamicQuery[2];
		for ( int i = 0; i < dq.length; i++ ){
			dq[i] = DynamicQueryFactoryUtil.forClass( clazz, PortletClassLoaderUtil.getClassLoader() );
		 }
		return dq;
	}
	
	private DynamicQuery[] getDqPair( Class<? extends BaseModelImpl<?>> clazz, List<Criterion>[] criteria ){
		DynamicQuery[] dq = new DynamicQuery[2];
		for ( int i = 0; i < dq.length; i++ ){
			dq[i] = DynamicQueryFactoryUtil.forClass( clazz, PortletClassLoaderUtil.getClassLoader() );
			for ( Criterion c: criteria[i] ){
				dq[i].add(c);
			}
		 }
		return dq;
	}
	
	private DynamicQuery[] getDqPair( Class<? extends BaseModelImpl<?>> clazz, List<Criterion> criteria ){
		DynamicQuery[] dq = new DynamicQuery[2];
		for ( int i = 0; i < dq.length; i++ ){
			dq[i] = DynamicQueryFactoryUtil.forClass( clazz, PortletClassLoaderUtil.getClassLoader() );
			for ( Criterion c: criteria ){
				dq[i].add(c);
			}
		 }
		return dq;
	}

	@Override
	public boolean isLazy(){
		return true;
	}
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	Projection[] projection;
	Property[] property;
	
}
